# The Code for Paper "Classifiers are Forgetful! Balancing the Mutual Causal Effects in Class-Incremental Learning"

## Requirements
```
torch                         2.0.1
accelerate                    0.21.0
adapter-transformers          3.2.1
numpy                         1.25.0
pandas                        2.0.3
Pillow                        10.0.0
timm                          0.6.13
tqdm                          4.65.0
transformers                  4.31.0
wandb                         0.15.7
```

## File Structures
```
.
├── datasets       # the folder for storing datasets
├── experiments    # the folder for storing experimental results
├── main_CL.py     # the python file to be executed
└── src            # the folder containing files for models, datas
    ├── config.py                # the file for adjusting hyper-parameters
    ├── models_classifier.py     # the file defines the classifiers
    ├── models_ic.py             # the file defines the models for image classification
    ├── trainer.py               # the file defines basic training procedure of IL
    ├── utils_buffer.py          # the file defines the algorithm for selecting buffer data
    ├── utils_data_ic.py         # the file defines functions for loading image classification data
    ├── utils_data.py            # the file defines the base class for the data in continual learning 
    ├── utils_eval.py            # the file defines function for evaluation
    └── utils_others.py          # the file defines other functions
```

## The following baselines are also included in this repository

| Method      | Reference | 
| ----------- | ----------- | 
| LwF         | https://github.com/ngailapdi/LWF        | 
| EWC   | https://github.com/shivamsaboo17/Overcoming-Catastrophic-forgetting-in-Neural-Networks       | 
| LUCIR   | https://github.com/hshustc/CVPR19_Incremental_Learning       | 
| PODNET   | https://github.com/arthurdouillard/incremental_learning.pytorch       | 
| DDE   | https://github.com/JoyHuYY1412/DDE_CIL       | 
| CLSER   | https://github.com/NeurAI-Lab/CLS-ER       | 
| MEMO   | https://github.com/wangkiw/ICLR23-MEMO       | 
